package com.example.blas.myapplication.clases;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.example.blas.myapplication.R;

import java.util.ArrayList;
import java.util.List;

public class AdaptadorDeGrilla extends BaseAdapter {
    private Context context;
    private ArrayList<grillaItem> Data;

    public AdaptadorDeGrilla(Context context) {
        this.context = context;
        this.Data = new ArrayList();
        Data.add(new grillaItem("demostracion",1));
        Data.add(new grillaItem("dessssss",2));
    }

    @Override
    public int getCount() {
        return Data.size();
    }

    @Override
    public grillaItem getItem(int position) {
        //return Data.ITEMS[position];
        return Data.get(position);
    }

    @Override
    public long getItemId(int position) {
        return getItem(position).getId();
    }

    @Override
    public View getView(int position, View view, ViewGroup viewGroup) {

        if (view == null) {
            LayoutInflater inflater = (LayoutInflater) context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            view = inflater.inflate(R.layout.grid_item, viewGroup, false);
        }

        TextView imagenCoche = (TextView) view.findViewById(R.id.id_coche);
        TextView nombreCoche = (TextView) view.findViewById(R.id.nombre_coche);

        final grillaItem item = getItem(position);
        imagenCoche.setText(Integer.toString(item.getId()));
        nombreCoche.setText(item.getNombre());

        return view;
    }

    public void addData(int id,String des) {
        Data.add(new grillaItem(des,id));
    }
    public void removData() {
        Data = new ArrayList();
    }
}