/*
 * Decompiled with CFR 0.152.
 */
package controles;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class Filtro
extends JLabel
implements MouseListener,
MouseMotionListener {
    private Point posicion = new Point(0, 0);
    private Dimension d = new Dimension(124, 150);
    private Point start_loc;
    private Point start_drag;
    private Point offset;
    private int nuevo_X = 1;
    private int nuevo_Y = 1;
    private int promedio = 100;
    private Image imgcolor;
    private BufferedImage imgnegro;
    private Boolean mono = true;
    private int tipoColor = 3;
    private String ruta;
    int[][] colores16 = new int[16][4];
    int[][] colores256 = new int[256][4];

    public Filtro() {
        this.arrayColores();
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setSize(this.d);
        this.setPreferredSize(this.d);
        this.setText("");
        this.setVisible(true);
        this.setLocation(this.posicion);
        this.setBorder(BorderFactory.createLineBorder(new Color(255, 128, 0), 1));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.start_drag = this.getScreenLocation(e);
        this.start_loc = this.getLocation();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.nuevo_X = this.getLocation().x;
        this.nuevo_Y = this.getLocation().y;
        this.setLocation(this.nuevo_X, this.nuevo_Y);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 0), 1));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setBorder(BorderFactory.createLineBorder(new Color(255, 128, 0), 1));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point current = this.getScreenLocation(e);
        this.offset = new Point((int)current.getX() - (int)this.start_drag.getX(), (int)current.getY() - (int)this.start_drag.getY());
        int x1 = (int)(this.start_loc.getX() + this.offset.getX());
        int y1 = (int)(this.start_loc.getY() + this.offset.getY());
        int x2 = x1 + this.getWidth();
        int y2 = y1 + this.getHeight();
        BufferedImage imgsel = (BufferedImage)this.imgcolor;
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (x2 > imgsel.getWidth()) {
            x1 = imgsel.getWidth() - this.getWidth();
        }
        if (y2 > imgsel.getHeight()) {
            y1 = imgsel.getHeight() - this.getHeight();
        }
        Point new_location = new Point(x1, y1);
        this.setLocation(new_location);
        this.aplicarFiltro();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private Point getScreenLocation(MouseEvent evt) {
        Point cursor = evt.getPoint();
        Point target_location = this.getLocationOnScreen();
        return new Point((int)(target_location.getX() + cursor.getX()), (int)(target_location.getY() + cursor.getY()));
    }

    public void setRuta(String m) {
        this.ruta = m;
    }

    public String getRuta() {
        return this.ruta;
    }

    public void setColor(int m) {
        this.tipoColor = m;
    }

    public int getColor() {
        return this.tipoColor;
    }

    public void setMono(Boolean m) {
        this.mono = m;
    }

    public Boolean getMono() {
        return this.mono;
    }

    public void aplicarFiltro() {
        this.aplicarFiltro(this.promedio, this.imgcolor);
    }

    public void aplicarFiltro(Image i) {
        this.aplicarFiltro(this.promedio, i);
    }

    public void aplicarFiltro(int p, Image i) {
        this.imgcolor = i;
        this.promedio = p;
        BufferedImage imgsel = (BufferedImage)this.imgcolor;
        int w = this.getWidth();
        int h = this.getHeight();
        int xn = this.getX();
        int yn = this.getY();
        if (imgsel != null) {
            this.imgnegro = this.mono != false ? new BufferedImage(w, h, 12) : new BufferedImage(w, h, 5);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    Color c = new Color(imgsel.getRGB(x + xn, y + yn));
                    int r = c.getRed();
                    int g = c.getGreen();
                    int b = c.getBlue();
                    if (this.mono.booleanValue()) {
                        r = r < this.promedio ? 0 : 255;
                        g = g < this.promedio ? 0 : 255;
                        b = b < this.promedio ? 0 : 255;
                    }
                    this.imgnegro.setRGB(x, y, new Color(r, g, b).getRGB());
                }
            }
        }
        this.setIcon(new ImageIcon(this.imgnegro));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void datos() {
        OutputStreamWriter fichero = null;
        PrintWriter pw = null;
        try {
            fichero = new FileWriter(this.ruta + "datos.txt");
            pw = new PrintWriter(fichero);
            for (int x = 0; x < this.getWidth(); ++x) {
                for (int y = 0; y < this.getHeight(); ++y) {
                    if (this.imgnegro.getRGB(x, y) == -1) continue;
                    pw.println(this.ceros(x));
                    pw.println(this.ceros(y));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != fichero) {
                    fichero.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void datos256(JProgressBar barra) {
        OutputStreamWriter fichero = null;
        PrintWriter pw = null;
        try {
            fichero = new FileWriter(this.ruta + "datos.txt");
            pw = new PrintWriter(fichero);
            barra.setMaximum(this.getWidth() - 1);
            int r = 0;
            int g = 0;
            int b = 0;
            int l = 0;
            for (int x = 0; x < this.getWidth(); ++x) {
                barra.setValue(x);
                block16: for (int y = 0; y < this.getHeight(); ++y) {
                    Color c = new Color(this.imgnegro.getRGB(x, y));
                    r = c.getRed();
                    g = c.getGreen();
                    b = c.getBlue();
                    pw.println(this.ceros(x));
                    pw.println(this.ceros(y));
                    switch (this.tipoColor) {
                        case 2: {
                            l = this.colorRGB16(c);
                            pw.println(this.ceros(l));
                            this.imgnegro.setRGB(x, y, new Color(this.colores16[l][1], this.colores16[l][2], this.colores16[l][3]).getRGB());
                            continue block16;
                        }
                        case 3: {
                            l = this.colorRGB256(c);
                            pw.println(this.ceros(l));
                            this.imgnegro.setRGB(x, y, new Color(this.colores256[l][1], this.colores256[l][2], this.colores256[l][3]).getRGB());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != fichero) {
                    fichero.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public String ceros(int n) {
        String numero = "000";
        numero = numero + Integer.toString(n);
        return numero.substring(numero.length() - 4, numero.length());
    }

    public int colorRGB16(Color color) {
        int respuesta = 0;
        double resant = 500.0;
        for (int n = 0; n <= 15; ++n) {
            double res = this.numeroColor(color, this.colores16[n][1], this.colores16[n][2], this.colores16[n][3]);
            if (!(res < resant)) continue;
            resant = res;
            respuesta = n;
        }
        return respuesta;
    }

    public int colorRGB256(Color color) {
        int respuesta = 0;
        double resant = 500.0;
        for (int n = 0; n <= 255; ++n) {
            double res = this.numeroColor(color, this.colores256[n][1], this.colores256[n][2], this.colores256[n][3]);
            if (!(res < resant)) continue;
            resant = res;
            respuesta = n;
        }
        return respuesta;
    }

    public double numeroColor(Color crgb, int r, int g, int b) {
        double dr = r - crgb.getRed();
        double dg = g - crgb.getGreen();
        double db = b - crgb.getBlue();
        double distancia = Math.sqrt(Math.pow(dr, 2.0) + Math.pow(dg, 2.0) + Math.pow(db, 2.0));
        return distancia;
    }

    private void arrayColores() {
        this.colores16[0][0] = 0;
        this.colores16[0][1] = 0;
        this.colores16[0][2] = 0;
        this.colores16[0][3] = 0;
        this.colores16[1][0] = 1;
        this.colores16[1][1] = 0;
        this.colores16[1][2] = 0;
        this.colores16[1][3] = 168;
        this.colores16[2][0] = 2;
        this.colores16[2][1] = 0;
        this.colores16[2][2] = 168;
        this.colores16[2][3] = 0;
        this.colores16[3][0] = 3;
        this.colores16[3][1] = 0;
        this.colores16[3][2] = 168;
        this.colores16[3][3] = 168;
        this.colores16[4][0] = 4;
        this.colores16[4][1] = 168;
        this.colores16[4][2] = 0;
        this.colores16[4][3] = 0;
        this.colores16[5][0] = 5;
        this.colores16[5][1] = 168;
        this.colores16[5][2] = 0;
        this.colores16[5][3] = 168;
        this.colores16[6][0] = 6;
        this.colores16[6][1] = 168;
        this.colores16[6][2] = 87;
        this.colores16[6][3] = 0;
        this.colores16[7][0] = 7;
        this.colores16[7][1] = 168;
        this.colores16[7][2] = 168;
        this.colores16[7][3] = 168;
        this.colores16[8][0] = 8;
        this.colores16[8][1] = 87;
        this.colores16[8][2] = 87;
        this.colores16[8][3] = 87;
        this.colores16[9][0] = 9;
        this.colores16[9][1] = 87;
        this.colores16[9][2] = 87;
        this.colores16[9][3] = 255;
        this.colores16[10][0] = 10;
        this.colores16[10][1] = 87;
        this.colores16[10][2] = 255;
        this.colores16[10][3] = 87;
        this.colores16[11][0] = 11;
        this.colores16[11][1] = 87;
        this.colores16[11][2] = 255;
        this.colores16[11][3] = 255;
        this.colores16[12][0] = 12;
        this.colores16[12][1] = 255;
        this.colores16[12][2] = 87;
        this.colores16[12][3] = 87;
        this.colores16[13][0] = 13;
        this.colores16[13][1] = 255;
        this.colores16[13][2] = 87;
        this.colores16[13][3] = 255;
        this.colores16[14][0] = 14;
        this.colores16[14][1] = 255;
        this.colores16[14][2] = 255;
        this.colores16[14][3] = 87;
        this.colores16[15][0] = 15;
        this.colores16[15][1] = 255;
        this.colores16[15][2] = 255;
        this.colores16[15][3] = 255;
        this.colores256[0][0] = 0;
        this.colores256[0][1] = 0;
        this.colores256[0][2] = 0;
        this.colores256[0][3] = 0;
        this.colores256[1][0] = 1;
        this.colores256[1][1] = 0;
        this.colores256[1][2] = 0;
        this.colores256[1][3] = 168;
        this.colores256[2][0] = 2;
        this.colores256[2][1] = 0;
        this.colores256[2][2] = 168;
        this.colores256[2][3] = 0;
        this.colores256[3][0] = 3;
        this.colores256[3][1] = 0;
        this.colores256[3][2] = 168;
        this.colores256[3][3] = 168;
        this.colores256[4][0] = 4;
        this.colores256[4][1] = 168;
        this.colores256[4][2] = 0;
        this.colores256[4][3] = 0;
        this.colores256[5][0] = 5;
        this.colores256[5][1] = 168;
        this.colores256[5][2] = 0;
        this.colores256[5][3] = 168;
        this.colores256[6][0] = 6;
        this.colores256[6][1] = 168;
        this.colores256[6][2] = 87;
        this.colores256[6][3] = 0;
        this.colores256[7][0] = 7;
        this.colores256[7][1] = 168;
        this.colores256[7][2] = 168;
        this.colores256[7][3] = 168;
        this.colores256[8][0] = 8;
        this.colores256[8][1] = 87;
        this.colores256[8][2] = 87;
        this.colores256[8][3] = 87;
        this.colores256[9][0] = 9;
        this.colores256[9][1] = 87;
        this.colores256[9][2] = 87;
        this.colores256[9][3] = 255;
        this.colores256[10][0] = 10;
        this.colores256[10][1] = 87;
        this.colores256[10][2] = 255;
        this.colores256[10][3] = 87;
        this.colores256[11][0] = 11;
        this.colores256[11][1] = 87;
        this.colores256[11][2] = 255;
        this.colores256[11][3] = 255;
        this.colores256[12][0] = 12;
        this.colores256[12][1] = 255;
        this.colores256[12][2] = 87;
        this.colores256[12][3] = 87;
        this.colores256[13][0] = 13;
        this.colores256[13][1] = 255;
        this.colores256[13][2] = 87;
        this.colores256[13][3] = 255;
        this.colores256[14][0] = 14;
        this.colores256[14][1] = 255;
        this.colores256[14][2] = 255;
        this.colores256[14][3] = 87;
        this.colores256[15][0] = 15;
        this.colores256[15][1] = 255;
        this.colores256[15][2] = 255;
        this.colores256[15][3] = 255;
        this.colores256[16][0] = 16;
        this.colores256[16][1] = 0;
        this.colores256[16][2] = 0;
        this.colores256[16][3] = 0;
        this.colores256[17][0] = 17;
        this.colores256[17][1] = 23;
        this.colores256[17][2] = 23;
        this.colores256[17][3] = 23;
        this.colores256[18][0] = 18;
        this.colores256[18][1] = 32;
        this.colores256[18][2] = 32;
        this.colores256[18][3] = 32;
        this.colores256[19][0] = 19;
        this.colores256[19][1] = 47;
        this.colores256[19][2] = 47;
        this.colores256[19][3] = 47;
        this.colores256[20][0] = 20;
        this.colores256[20][1] = 56;
        this.colores256[20][2] = 56;
        this.colores256[20][3] = 56;
        this.colores256[21][0] = 21;
        this.colores256[21][1] = 71;
        this.colores256[21][2] = 71;
        this.colores256[21][3] = 71;
        this.colores256[22][0] = 22;
        this.colores256[22][1] = 80;
        this.colores256[22][2] = 80;
        this.colores256[22][3] = 80;
        this.colores256[23][0] = 23;
        this.colores256[23][1] = 96;
        this.colores256[23][2] = 96;
        this.colores256[23][3] = 96;
        this.colores256[24][0] = 24;
        this.colores256[24][1] = 112;
        this.colores256[24][2] = 112;
        this.colores256[24][3] = 112;
        this.colores256[25][0] = 25;
        this.colores256[25][1] = 128;
        this.colores256[25][2] = 128;
        this.colores256[25][3] = 128;
        this.colores256[26][0] = 26;
        this.colores256[26][1] = 144;
        this.colores256[26][2] = 144;
        this.colores256[26][3] = 144;
        this.colores256[27][0] = 27;
        this.colores256[27][1] = 160;
        this.colores256[27][2] = 160;
        this.colores256[27][3] = 160;
        this.colores256[28][0] = 28;
        this.colores256[28][1] = 183;
        this.colores256[28][2] = 183;
        this.colores256[28][3] = 183;
        this.colores256[29][0] = 29;
        this.colores256[29][1] = 200;
        this.colores256[29][2] = 200;
        this.colores256[29][3] = 200;
        this.colores256[30][0] = 30;
        this.colores256[30][1] = 224;
        this.colores256[30][2] = 224;
        this.colores256[30][3] = 224;
        this.colores256[31][0] = 31;
        this.colores256[31][1] = 255;
        this.colores256[31][2] = 255;
        this.colores256[31][3] = 255;
        this.colores256[32][0] = 32;
        this.colores256[32][1] = 0;
        this.colores256[32][2] = 0;
        this.colores256[32][3] = 255;
        this.colores256[33][0] = 33;
        this.colores256[33][1] = 64;
        this.colores256[33][2] = 0;
        this.colores256[33][3] = 255;
        this.colores256[34][0] = 34;
        this.colores256[34][1] = 127;
        this.colores256[34][2] = 0;
        this.colores256[34][3] = 255;
        this.colores256[35][0] = 35;
        this.colores256[35][1] = 191;
        this.colores256[35][2] = 0;
        this.colores256[35][3] = 255;
        this.colores256[36][0] = 36;
        this.colores256[36][1] = 255;
        this.colores256[36][2] = 0;
        this.colores256[36][3] = 255;
        this.colores256[37][0] = 37;
        this.colores256[37][1] = 255;
        this.colores256[37][2] = 0;
        this.colores256[37][3] = 191;
        this.colores256[38][0] = 38;
        this.colores256[38][1] = 255;
        this.colores256[38][2] = 0;
        this.colores256[38][3] = 127;
        this.colores256[39][0] = 39;
        this.colores256[39][1] = 255;
        this.colores256[39][2] = 0;
        this.colores256[39][3] = 64;
        this.colores256[40][0] = 40;
        this.colores256[40][1] = 255;
        this.colores256[40][2] = 0;
        this.colores256[40][3] = 0;
        this.colores256[41][0] = 41;
        this.colores256[41][1] = 255;
        this.colores256[41][2] = 64;
        this.colores256[41][3] = 0;
        this.colores256[42][0] = 42;
        this.colores256[42][1] = 255;
        this.colores256[42][2] = 127;
        this.colores256[42][3] = 0;
        this.colores256[43][0] = 43;
        this.colores256[43][1] = 255;
        this.colores256[43][2] = 191;
        this.colores256[43][3] = 0;
        this.colores256[44][0] = 44;
        this.colores256[44][1] = 255;
        this.colores256[44][2] = 255;
        this.colores256[44][3] = 0;
        this.colores256[45][0] = 45;
        this.colores256[45][1] = 191;
        this.colores256[45][2] = 255;
        this.colores256[45][3] = 0;
        this.colores256[46][0] = 46;
        this.colores256[46][1] = 127;
        this.colores256[46][2] = 255;
        this.colores256[46][3] = 0;
        this.colores256[47][0] = 47;
        this.colores256[47][1] = 64;
        this.colores256[47][2] = 255;
        this.colores256[47][3] = 0;
        this.colores256[48][0] = 48;
        this.colores256[48][1] = 0;
        this.colores256[48][2] = 255;
        this.colores256[48][3] = 0;
        this.colores256[49][0] = 49;
        this.colores256[49][1] = 0;
        this.colores256[49][2] = 255;
        this.colores256[49][3] = 64;
        this.colores256[50][0] = 50;
        this.colores256[50][1] = 0;
        this.colores256[50][2] = 255;
        this.colores256[50][3] = 127;
        this.colores256[51][0] = 51;
        this.colores256[51][1] = 0;
        this.colores256[51][2] = 255;
        this.colores256[51][3] = 191;
        this.colores256[52][0] = 52;
        this.colores256[52][1] = 0;
        this.colores256[52][2] = 255;
        this.colores256[52][3] = 255;
        this.colores256[53][0] = 53;
        this.colores256[53][1] = 0;
        this.colores256[53][2] = 191;
        this.colores256[53][3] = 255;
        this.colores256[54][0] = 54;
        this.colores256[54][1] = 0;
        this.colores256[54][2] = 127;
        this.colores256[54][3] = 255;
        this.colores256[55][0] = 55;
        this.colores256[55][1] = 0;
        this.colores256[55][2] = 64;
        this.colores256[55][3] = 255;
        this.colores256[56][0] = 56;
        this.colores256[56][1] = 127;
        this.colores256[56][2] = 127;
        this.colores256[56][3] = 255;
        this.colores256[57][0] = 57;
        this.colores256[57][1] = 159;
        this.colores256[57][2] = 127;
        this.colores256[57][3] = 255;
        this.colores256[58][0] = 58;
        this.colores256[58][1] = 191;
        this.colores256[58][2] = 127;
        this.colores256[58][3] = 255;
        this.colores256[59][0] = 59;
        this.colores256[59][1] = 223;
        this.colores256[59][2] = 127;
        this.colores256[59][3] = 255;
        this.colores256[60][0] = 60;
        this.colores256[60][1] = 255;
        this.colores256[60][2] = 127;
        this.colores256[60][3] = 255;
        this.colores256[61][0] = 61;
        this.colores256[61][1] = 255;
        this.colores256[61][2] = 127;
        this.colores256[61][3] = 223;
        this.colores256[62][0] = 62;
        this.colores256[62][1] = 255;
        this.colores256[62][2] = 127;
        this.colores256[62][3] = 191;
        this.colores256[63][0] = 63;
        this.colores256[63][1] = 255;
        this.colores256[63][2] = 127;
        this.colores256[63][3] = 159;
        this.colores256[64][0] = 64;
        this.colores256[64][1] = 255;
        this.colores256[64][2] = 127;
        this.colores256[64][3] = 127;
        this.colores256[65][0] = 65;
        this.colores256[65][1] = 255;
        this.colores256[65][2] = 159;
        this.colores256[65][3] = 127;
        this.colores256[66][0] = 66;
        this.colores256[66][1] = 255;
        this.colores256[66][2] = 191;
        this.colores256[66][3] = 127;
        this.colores256[67][0] = 67;
        this.colores256[67][1] = 255;
        this.colores256[67][2] = 223;
        this.colores256[67][3] = 127;
        this.colores256[68][0] = 68;
        this.colores256[68][1] = 255;
        this.colores256[68][2] = 255;
        this.colores256[68][3] = 127;
        this.colores256[69][0] = 69;
        this.colores256[69][1] = 223;
        this.colores256[69][2] = 255;
        this.colores256[69][3] = 127;
        this.colores256[70][0] = 70;
        this.colores256[70][1] = 191;
        this.colores256[70][2] = 255;
        this.colores256[70][3] = 127;
        this.colores256[71][0] = 71;
        this.colores256[71][1] = 159;
        this.colores256[71][2] = 255;
        this.colores256[71][3] = 127;
        this.colores256[72][0] = 72;
        this.colores256[72][1] = 127;
        this.colores256[72][2] = 255;
        this.colores256[72][3] = 127;
        this.colores256[73][0] = 73;
        this.colores256[73][1] = 127;
        this.colores256[73][2] = 255;
        this.colores256[73][3] = 159;
        this.colores256[74][0] = 74;
        this.colores256[74][1] = 127;
        this.colores256[74][2] = 255;
        this.colores256[74][3] = 191;
        this.colores256[75][0] = 75;
        this.colores256[75][1] = 127;
        this.colores256[75][2] = 255;
        this.colores256[75][3] = 223;
        this.colores256[76][0] = 76;
        this.colores256[76][1] = 127;
        this.colores256[76][2] = 255;
        this.colores256[76][3] = 255;
        this.colores256[77][0] = 77;
        this.colores256[77][1] = 127;
        this.colores256[77][2] = 223;
        this.colores256[77][3] = 255;
        this.colores256[78][0] = 78;
        this.colores256[78][1] = 127;
        this.colores256[78][2] = 191;
        this.colores256[78][3] = 255;
        this.colores256[79][0] = 79;
        this.colores256[79][1] = 127;
        this.colores256[79][2] = 159;
        this.colores256[79][3] = 255;
        this.colores256[80][0] = 80;
        this.colores256[80][1] = 183;
        this.colores256[80][2] = 183;
        this.colores256[80][3] = 255;
        this.colores256[81][0] = 81;
        this.colores256[81][1] = 199;
        this.colores256[81][2] = 183;
        this.colores256[81][3] = 255;
        this.colores256[82][0] = 82;
        this.colores256[82][1] = 216;
        this.colores256[82][2] = 183;
        this.colores256[82][3] = 255;
        this.colores256[83][0] = 83;
        this.colores256[83][1] = 232;
        this.colores256[83][2] = 183;
        this.colores256[83][3] = 255;
        this.colores256[84][0] = 84;
        this.colores256[84][1] = 255;
        this.colores256[84][2] = 183;
        this.colores256[84][3] = 255;
        this.colores256[85][0] = 85;
        this.colores256[85][1] = 255;
        this.colores256[85][2] = 183;
        this.colores256[85][3] = 232;
        this.colores256[86][0] = 86;
        this.colores256[86][1] = 255;
        this.colores256[86][2] = 183;
        this.colores256[86][3] = 216;
        this.colores256[87][0] = 87;
        this.colores256[87][1] = 255;
        this.colores256[87][2] = 183;
        this.colores256[87][3] = 199;
        this.colores256[88][0] = 88;
        this.colores256[88][1] = 255;
        this.colores256[88][2] = 183;
        this.colores256[88][3] = 183;
        this.colores256[89][0] = 89;
        this.colores256[89][1] = 255;
        this.colores256[89][2] = 199;
        this.colores256[89][3] = 183;
        this.colores256[90][0] = 90;
        this.colores256[90][1] = 255;
        this.colores256[90][2] = 216;
        this.colores256[90][3] = 183;
        this.colores256[91][0] = 91;
        this.colores256[91][1] = 255;
        this.colores256[91][2] = 232;
        this.colores256[91][3] = 183;
        this.colores256[92][0] = 92;
        this.colores256[92][1] = 255;
        this.colores256[92][2] = 255;
        this.colores256[92][3] = 183;
        this.colores256[93][0] = 93;
        this.colores256[93][1] = 232;
        this.colores256[93][2] = 255;
        this.colores256[93][3] = 183;
        this.colores256[94][0] = 94;
        this.colores256[94][1] = 216;
        this.colores256[94][2] = 255;
        this.colores256[94][3] = 183;
        this.colores256[95][0] = 95;
        this.colores256[95][1] = 199;
        this.colores256[95][2] = 255;
        this.colores256[95][3] = 183;
        this.colores256[96][0] = 96;
        this.colores256[96][1] = 183;
        this.colores256[96][2] = 255;
        this.colores256[96][3] = 183;
        this.colores256[97][0] = 97;
        this.colores256[97][1] = 183;
        this.colores256[97][2] = 255;
        this.colores256[97][3] = 199;
        this.colores256[98][0] = 98;
        this.colores256[98][1] = 183;
        this.colores256[98][2] = 255;
        this.colores256[98][3] = 216;
        this.colores256[99][0] = 99;
        this.colores256[99][1] = 183;
        this.colores256[99][2] = 255;
        this.colores256[99][3] = 232;
        this.colores256[100][0] = 100;
        this.colores256[100][1] = 183;
        this.colores256[100][2] = 255;
        this.colores256[100][3] = 255;
        this.colores256[101][0] = 101;
        this.colores256[101][1] = 183;
        this.colores256[101][2] = 232;
        this.colores256[101][3] = 255;
        this.colores256[102][0] = 102;
        this.colores256[102][1] = 183;
        this.colores256[102][2] = 216;
        this.colores256[102][3] = 255;
        this.colores256[103][0] = 103;
        this.colores256[103][1] = 183;
        this.colores256[103][2] = 199;
        this.colores256[103][3] = 255;
        this.colores256[104][0] = 104;
        this.colores256[104][1] = 0;
        this.colores256[104][2] = 0;
        this.colores256[104][3] = 112;
        this.colores256[105][0] = 105;
        this.colores256[105][1] = 31;
        this.colores256[105][2] = 0;
        this.colores256[105][3] = 112;
        this.colores256[106][0] = 106;
        this.colores256[106][1] = 56;
        this.colores256[106][2] = 0;
        this.colores256[106][3] = 112;
        this.colores256[107][0] = 107;
        this.colores256[107][1] = 87;
        this.colores256[107][2] = 0;
        this.colores256[107][3] = 112;
        this.colores256[108][0] = 108;
        this.colores256[108][1] = 112;
        this.colores256[108][2] = 0;
        this.colores256[108][3] = 112;
        this.colores256[109][0] = 109;
        this.colores256[109][1] = 112;
        this.colores256[109][2] = 0;
        this.colores256[109][3] = 87;
        this.colores256[110][0] = 110;
        this.colores256[110][1] = 112;
        this.colores256[110][2] = 0;
        this.colores256[110][3] = 56;
        this.colores256[111][0] = 111;
        this.colores256[111][1] = 112;
        this.colores256[111][2] = 0;
        this.colores256[111][3] = 31;
        this.colores256[112][0] = 112;
        this.colores256[112][1] = 112;
        this.colores256[112][2] = 0;
        this.colores256[112][3] = 0;
        this.colores256[113][0] = 113;
        this.colores256[113][1] = 112;
        this.colores256[113][2] = 31;
        this.colores256[113][3] = 0;
        this.colores256[114][0] = 114;
        this.colores256[114][1] = 112;
        this.colores256[114][2] = 56;
        this.colores256[114][3] = 0;
        this.colores256[115][0] = 115;
        this.colores256[115][1] = 112;
        this.colores256[115][2] = 87;
        this.colores256[115][3] = 0;
        this.colores256[116][0] = 116;
        this.colores256[116][1] = 112;
        this.colores256[116][2] = 112;
        this.colores256[116][3] = 0;
        this.colores256[117][0] = 117;
        this.colores256[117][1] = 87;
        this.colores256[117][2] = 112;
        this.colores256[117][3] = 0;
        this.colores256[118][0] = 118;
        this.colores256[118][1] = 56;
        this.colores256[118][2] = 112;
        this.colores256[118][3] = 0;
        this.colores256[119][0] = 119;
        this.colores256[119][1] = 31;
        this.colores256[119][2] = 112;
        this.colores256[119][3] = 0;
        this.colores256[120][0] = 120;
        this.colores256[120][1] = 0;
        this.colores256[120][2] = 112;
        this.colores256[120][3] = 0;
        this.colores256[121][0] = 121;
        this.colores256[121][1] = 0;
        this.colores256[121][2] = 112;
        this.colores256[121][3] = 31;
        this.colores256[122][0] = 122;
        this.colores256[122][1] = 0;
        this.colores256[122][2] = 112;
        this.colores256[122][3] = 56;
        this.colores256[123][0] = 123;
        this.colores256[123][1] = 0;
        this.colores256[123][2] = 112;
        this.colores256[123][3] = 87;
        this.colores256[124][0] = 124;
        this.colores256[124][1] = 0;
        this.colores256[124][2] = 112;
        this.colores256[124][3] = 112;
        this.colores256[125][0] = 125;
        this.colores256[125][1] = 0;
        this.colores256[125][2] = 87;
        this.colores256[125][3] = 112;
        this.colores256[126][0] = 126;
        this.colores256[126][1] = 0;
        this.colores256[126][2] = 56;
        this.colores256[126][3] = 112;
        this.colores256[127][0] = 127;
        this.colores256[127][1] = 0;
        this.colores256[127][2] = 31;
        this.colores256[127][3] = 112;
        this.colores256[128][0] = 128;
        this.colores256[128][1] = 56;
        this.colores256[128][2] = 56;
        this.colores256[128][3] = 112;
        this.colores256[129][0] = 129;
        this.colores256[129][1] = 71;
        this.colores256[129][2] = 56;
        this.colores256[129][3] = 112;
        this.colores256[130][0] = 130;
        this.colores256[130][1] = 87;
        this.colores256[130][2] = 56;
        this.colores256[130][3] = 112;
        this.colores256[131][0] = 131;
        this.colores256[131][1] = 96;
        this.colores256[131][2] = 56;
        this.colores256[131][3] = 112;
        this.colores256[132][0] = 132;
        this.colores256[132][1] = 112;
        this.colores256[132][2] = 56;
        this.colores256[132][3] = 112;
        this.colores256[133][0] = 133;
        this.colores256[133][1] = 112;
        this.colores256[133][2] = 56;
        this.colores256[133][3] = 96;
        this.colores256[134][0] = 134;
        this.colores256[134][1] = 112;
        this.colores256[134][2] = 56;
        this.colores256[134][3] = 87;
        this.colores256[135][0] = 135;
        this.colores256[135][1] = 112;
        this.colores256[135][2] = 56;
        this.colores256[135][3] = 71;
        this.colores256[136][0] = 136;
        this.colores256[136][1] = 112;
        this.colores256[136][2] = 56;
        this.colores256[136][3] = 56;
        this.colores256[137][0] = 137;
        this.colores256[137][1] = 112;
        this.colores256[137][2] = 71;
        this.colores256[137][3] = 56;
        this.colores256[138][0] = 138;
        this.colores256[138][1] = 112;
        this.colores256[138][2] = 87;
        this.colores256[138][3] = 56;
        this.colores256[139][0] = 139;
        this.colores256[139][1] = 112;
        this.colores256[139][2] = 96;
        this.colores256[139][3] = 56;
        this.colores256[140][0] = 140;
        this.colores256[140][1] = 112;
        this.colores256[140][2] = 112;
        this.colores256[140][3] = 56;
        this.colores256[141][0] = 141;
        this.colores256[141][1] = 96;
        this.colores256[141][2] = 112;
        this.colores256[141][3] = 56;
        this.colores256[142][0] = 142;
        this.colores256[142][1] = 87;
        this.colores256[142][2] = 112;
        this.colores256[142][3] = 56;
        this.colores256[143][0] = 143;
        this.colores256[143][1] = 71;
        this.colores256[143][2] = 112;
        this.colores256[143][3] = 56;
        this.colores256[144][0] = 144;
        this.colores256[144][1] = 56;
        this.colores256[144][2] = 112;
        this.colores256[144][3] = 56;
        this.colores256[145][0] = 145;
        this.colores256[145][1] = 56;
        this.colores256[145][2] = 112;
        this.colores256[145][3] = 71;
        this.colores256[146][0] = 146;
        this.colores256[146][1] = 56;
        this.colores256[146][2] = 112;
        this.colores256[146][3] = 87;
        this.colores256[147][0] = 147;
        this.colores256[147][1] = 56;
        this.colores256[147][2] = 112;
        this.colores256[147][3] = 96;
        this.colores256[148][0] = 148;
        this.colores256[148][1] = 56;
        this.colores256[148][2] = 112;
        this.colores256[148][3] = 112;
        this.colores256[149][0] = 149;
        this.colores256[149][1] = 56;
        this.colores256[149][2] = 96;
        this.colores256[149][3] = 112;
        this.colores256[150][0] = 150;
        this.colores256[150][1] = 56;
        this.colores256[150][2] = 87;
        this.colores256[150][3] = 112;
        this.colores256[151][0] = 151;
        this.colores256[151][1] = 56;
        this.colores256[151][2] = 71;
        this.colores256[151][3] = 112;
        this.colores256[152][0] = 152;
        this.colores256[152][1] = 80;
        this.colores256[152][2] = 80;
        this.colores256[152][3] = 112;
        this.colores256[153][0] = 153;
        this.colores256[153][1] = 88;
        this.colores256[153][2] = 80;
        this.colores256[153][3] = 112;
        this.colores256[154][0] = 154;
        this.colores256[154][1] = 96;
        this.colores256[154][2] = 80;
        this.colores256[154][3] = 112;
        this.colores256[155][0] = 155;
        this.colores256[155][1] = 104;
        this.colores256[155][2] = 80;
        this.colores256[155][3] = 112;
        this.colores256[156][0] = 156;
        this.colores256[156][1] = 112;
        this.colores256[156][2] = 80;
        this.colores256[156][3] = 112;
        this.colores256[157][0] = 157;
        this.colores256[157][1] = 112;
        this.colores256[157][2] = 80;
        this.colores256[157][3] = 104;
        this.colores256[158][0] = 158;
        this.colores256[158][1] = 112;
        this.colores256[158][2] = 80;
        this.colores256[158][3] = 96;
        this.colores256[159][0] = 159;
        this.colores256[159][1] = 112;
        this.colores256[159][2] = 80;
        this.colores256[159][3] = 88;
        this.colores256[160][0] = 160;
        this.colores256[160][1] = 112;
        this.colores256[160][2] = 80;
        this.colores256[160][3] = 80;
        this.colores256[161][0] = 161;
        this.colores256[161][1] = 112;
        this.colores256[161][2] = 88;
        this.colores256[161][3] = 80;
        this.colores256[162][0] = 162;
        this.colores256[162][1] = 112;
        this.colores256[162][2] = 96;
        this.colores256[162][3] = 80;
        this.colores256[163][0] = 163;
        this.colores256[163][1] = 112;
        this.colores256[163][2] = 104;
        this.colores256[163][3] = 80;
        this.colores256[164][0] = 164;
        this.colores256[164][1] = 112;
        this.colores256[164][2] = 112;
        this.colores256[164][3] = 80;
        this.colores256[165][0] = 165;
        this.colores256[165][1] = 104;
        this.colores256[165][2] = 112;
        this.colores256[165][3] = 80;
        this.colores256[166][0] = 166;
        this.colores256[166][1] = 96;
        this.colores256[166][2] = 112;
        this.colores256[166][3] = 80;
        this.colores256[167][0] = 167;
        this.colores256[167][1] = 88;
        this.colores256[167][2] = 112;
        this.colores256[167][3] = 80;
        this.colores256[168][0] = 168;
        this.colores256[168][1] = 80;
        this.colores256[168][2] = 112;
        this.colores256[168][3] = 80;
        this.colores256[169][0] = 169;
        this.colores256[169][1] = 80;
        this.colores256[169][2] = 112;
        this.colores256[169][3] = 88;
        this.colores256[170][0] = 170;
        this.colores256[170][1] = 80;
        this.colores256[170][2] = 112;
        this.colores256[170][3] = 96;
        this.colores256[171][0] = 171;
        this.colores256[171][1] = 80;
        this.colores256[171][2] = 112;
        this.colores256[171][3] = 104;
        this.colores256[172][0] = 172;
        this.colores256[172][1] = 80;
        this.colores256[172][2] = 112;
        this.colores256[172][3] = 112;
        this.colores256[173][0] = 173;
        this.colores256[173][1] = 80;
        this.colores256[173][2] = 104;
        this.colores256[173][3] = 112;
        this.colores256[174][0] = 174;
        this.colores256[174][1] = 80;
        this.colores256[174][2] = 96;
        this.colores256[174][3] = 112;
        this.colores256[175][0] = 175;
        this.colores256[175][1] = 80;
        this.colores256[175][2] = 88;
        this.colores256[175][3] = 112;
        this.colores256[176][0] = 176;
        this.colores256[176][1] = 0;
        this.colores256[176][2] = 0;
        this.colores256[176][3] = 64;
        this.colores256[177][0] = 177;
        this.colores256[177][1] = 16;
        this.colores256[177][2] = 0;
        this.colores256[177][3] = 64;
        this.colores256[178][0] = 178;
        this.colores256[178][1] = 32;
        this.colores256[178][2] = 0;
        this.colores256[178][3] = 64;
        this.colores256[179][0] = 179;
        this.colores256[179][1] = 48;
        this.colores256[179][2] = 0;
        this.colores256[179][3] = 64;
        this.colores256[180][0] = 180;
        this.colores256[180][1] = 64;
        this.colores256[180][2] = 0;
        this.colores256[180][3] = 64;
        this.colores256[181][0] = 181;
        this.colores256[181][1] = 64;
        this.colores256[181][2] = 0;
        this.colores256[181][3] = 48;
        this.colores256[182][0] = 182;
        this.colores256[182][1] = 64;
        this.colores256[182][2] = 0;
        this.colores256[182][3] = 32;
        this.colores256[183][0] = 183;
        this.colores256[183][1] = 64;
        this.colores256[183][2] = 0;
        this.colores256[183][3] = 16;
        this.colores256[184][0] = 184;
        this.colores256[184][1] = 64;
        this.colores256[184][2] = 0;
        this.colores256[184][3] = 0;
        this.colores256[185][0] = 185;
        this.colores256[185][1] = 64;
        this.colores256[185][2] = 16;
        this.colores256[185][3] = 0;
        this.colores256[186][0] = 186;
        this.colores256[186][1] = 64;
        this.colores256[186][2] = 32;
        this.colores256[186][3] = 0;
        this.colores256[187][0] = 187;
        this.colores256[187][1] = 64;
        this.colores256[187][2] = 48;
        this.colores256[187][3] = 0;
        this.colores256[188][0] = 188;
        this.colores256[188][1] = 64;
        this.colores256[188][2] = 64;
        this.colores256[188][3] = 0;
        this.colores256[189][0] = 189;
        this.colores256[189][1] = 48;
        this.colores256[189][2] = 64;
        this.colores256[189][3] = 0;
        this.colores256[190][0] = 190;
        this.colores256[190][1] = 32;
        this.colores256[190][2] = 64;
        this.colores256[190][3] = 0;
        this.colores256[191][0] = 191;
        this.colores256[191][1] = 16;
        this.colores256[191][2] = 64;
        this.colores256[191][3] = 0;
        this.colores256[192][0] = 192;
        this.colores256[192][1] = 0;
        this.colores256[192][2] = 64;
        this.colores256[192][3] = 0;
        this.colores256[193][0] = 193;
        this.colores256[193][1] = 0;
        this.colores256[193][2] = 64;
        this.colores256[193][3] = 16;
        this.colores256[194][0] = 194;
        this.colores256[194][1] = 0;
        this.colores256[194][2] = 64;
        this.colores256[194][3] = 32;
        this.colores256[195][0] = 195;
        this.colores256[195][1] = 0;
        this.colores256[195][2] = 64;
        this.colores256[195][3] = 48;
        this.colores256[196][0] = 196;
        this.colores256[196][1] = 0;
        this.colores256[196][2] = 64;
        this.colores256[196][3] = 64;
        this.colores256[197][0] = 197;
        this.colores256[197][1] = 0;
        this.colores256[197][2] = 48;
        this.colores256[197][3] = 64;
        this.colores256[198][0] = 198;
        this.colores256[198][1] = 0;
        this.colores256[198][2] = 32;
        this.colores256[198][3] = 64;
        this.colores256[199][0] = 199;
        this.colores256[199][1] = 0;
        this.colores256[199][2] = 16;
        this.colores256[199][3] = 64;
        this.colores256[200][0] = 200;
        this.colores256[200][1] = 32;
        this.colores256[200][2] = 32;
        this.colores256[200][3] = 64;
        this.colores256[201][0] = 201;
        this.colores256[201][1] = 40;
        this.colores256[201][2] = 32;
        this.colores256[201][3] = 64;
        this.colores256[202][0] = 202;
        this.colores256[202][1] = 48;
        this.colores256[202][2] = 32;
        this.colores256[202][3] = 64;
        this.colores256[203][0] = 203;
        this.colores256[203][1] = 56;
        this.colores256[203][2] = 32;
        this.colores256[203][3] = 64;
        this.colores256[204][0] = 204;
        this.colores256[204][1] = 64;
        this.colores256[204][2] = 32;
        this.colores256[204][3] = 64;
        this.colores256[205][0] = 205;
        this.colores256[205][1] = 64;
        this.colores256[205][2] = 32;
        this.colores256[205][3] = 56;
        this.colores256[206][0] = 206;
        this.colores256[206][1] = 64;
        this.colores256[206][2] = 32;
        this.colores256[206][3] = 48;
        this.colores256[207][0] = 207;
        this.colores256[207][1] = 64;
        this.colores256[207][2] = 32;
        this.colores256[207][3] = 40;
        this.colores256[208][0] = 208;
        this.colores256[208][1] = 64;
        this.colores256[208][2] = 32;
        this.colores256[208][3] = 32;
        this.colores256[209][0] = 209;
        this.colores256[209][1] = 64;
        this.colores256[209][2] = 40;
        this.colores256[209][3] = 32;
        this.colores256[210][0] = 210;
        this.colores256[210][1] = 64;
        this.colores256[210][2] = 48;
        this.colores256[210][3] = 32;
        this.colores256[211][0] = 211;
        this.colores256[211][1] = 64;
        this.colores256[211][2] = 56;
        this.colores256[211][3] = 32;
        this.colores256[212][0] = 212;
        this.colores256[212][1] = 64;
        this.colores256[212][2] = 64;
        this.colores256[212][3] = 32;
        this.colores256[213][0] = 213;
        this.colores256[213][1] = 56;
        this.colores256[213][2] = 64;
        this.colores256[213][3] = 32;
        this.colores256[214][0] = 214;
        this.colores256[214][1] = 48;
        this.colores256[214][2] = 64;
        this.colores256[214][3] = 32;
        this.colores256[215][0] = 215;
        this.colores256[215][1] = 40;
        this.colores256[215][2] = 64;
        this.colores256[215][3] = 32;
        this.colores256[216][0] = 216;
        this.colores256[216][1] = 32;
        this.colores256[216][2] = 64;
        this.colores256[216][3] = 32;
        this.colores256[217][0] = 217;
        this.colores256[217][1] = 32;
        this.colores256[217][2] = 64;
        this.colores256[217][3] = 40;
        this.colores256[218][0] = 218;
        this.colores256[218][1] = 32;
        this.colores256[218][2] = 64;
        this.colores256[218][3] = 48;
        this.colores256[219][0] = 219;
        this.colores256[219][1] = 32;
        this.colores256[219][2] = 64;
        this.colores256[219][3] = 56;
        this.colores256[220][0] = 220;
        this.colores256[220][1] = 32;
        this.colores256[220][2] = 64;
        this.colores256[220][3] = 64;
        this.colores256[221][0] = 221;
        this.colores256[221][1] = 32;
        this.colores256[221][2] = 56;
        this.colores256[221][3] = 64;
        this.colores256[222][0] = 222;
        this.colores256[222][1] = 32;
        this.colores256[222][2] = 48;
        this.colores256[222][3] = 64;
        this.colores256[223][0] = 223;
        this.colores256[223][1] = 32;
        this.colores256[223][2] = 40;
        this.colores256[223][3] = 64;
        this.colores256[224][0] = 224;
        this.colores256[224][1] = 47;
        this.colores256[224][2] = 47;
        this.colores256[224][3] = 64;
        this.colores256[225][0] = 225;
        this.colores256[225][1] = 48;
        this.colores256[225][2] = 47;
        this.colores256[225][3] = 64;
        this.colores256[226][0] = 226;
        this.colores256[226][1] = 55;
        this.colores256[226][2] = 47;
        this.colores256[226][3] = 64;
        this.colores256[227][0] = 227;
        this.colores256[227][1] = 63;
        this.colores256[227][2] = 47;
        this.colores256[227][3] = 64;
        this.colores256[228][0] = 228;
        this.colores256[228][1] = 64;
        this.colores256[228][2] = 47;
        this.colores256[228][3] = 64;
        this.colores256[229][0] = 229;
        this.colores256[229][1] = 64;
        this.colores256[229][2] = 47;
        this.colores256[229][3] = 63;
        this.colores256[230][0] = 230;
        this.colores256[230][1] = 64;
        this.colores256[230][2] = 47;
        this.colores256[230][3] = 55;
        this.colores256[231][0] = 231;
        this.colores256[231][1] = 64;
        this.colores256[231][2] = 47;
        this.colores256[231][3] = 48;
        this.colores256[232][0] = 232;
        this.colores256[232][1] = 64;
        this.colores256[232][2] = 47;
        this.colores256[232][3] = 47;
        this.colores256[233][0] = 233;
        this.colores256[233][1] = 64;
        this.colores256[233][2] = 48;
        this.colores256[233][3] = 47;
        this.colores256[234][0] = 234;
        this.colores256[234][1] = 64;
        this.colores256[234][2] = 55;
        this.colores256[234][3] = 47;
        this.colores256[235][0] = 235;
        this.colores256[235][1] = 64;
        this.colores256[235][2] = 63;
        this.colores256[235][3] = 47;
        this.colores256[236][0] = 236;
        this.colores256[236][1] = 64;
        this.colores256[236][2] = 64;
        this.colores256[236][3] = 47;
        this.colores256[237][0] = 237;
        this.colores256[237][1] = 63;
        this.colores256[237][2] = 64;
        this.colores256[237][3] = 47;
        this.colores256[238][0] = 238;
        this.colores256[238][1] = 55;
        this.colores256[238][2] = 64;
        this.colores256[238][3] = 47;
        this.colores256[239][0] = 239;
        this.colores256[239][1] = 48;
        this.colores256[239][2] = 64;
        this.colores256[239][3] = 47;
        this.colores256[240][0] = 240;
        this.colores256[240][1] = 47;
        this.colores256[240][2] = 64;
        this.colores256[240][3] = 47;
        this.colores256[241][0] = 241;
        this.colores256[241][1] = 47;
        this.colores256[241][2] = 64;
        this.colores256[241][3] = 48;
        this.colores256[242][0] = 242;
        this.colores256[242][1] = 47;
        this.colores256[242][2] = 64;
        this.colores256[242][3] = 55;
        this.colores256[243][0] = 243;
        this.colores256[243][1] = 47;
        this.colores256[243][2] = 64;
        this.colores256[243][3] = 63;
        this.colores256[244][0] = 244;
        this.colores256[244][1] = 47;
        this.colores256[244][2] = 64;
        this.colores256[244][3] = 64;
        this.colores256[245][0] = 245;
        this.colores256[245][1] = 47;
        this.colores256[245][2] = 63;
        this.colores256[245][3] = 64;
        this.colores256[246][0] = 246;
        this.colores256[246][1] = 47;
        this.colores256[246][2] = 55;
        this.colores256[246][3] = 64;
        this.colores256[247][0] = 247;
        this.colores256[247][1] = 47;
        this.colores256[247][2] = 48;
        this.colores256[247][3] = 64;
        this.colores256[248][0] = 248;
        this.colores256[248][1] = 0;
        this.colores256[248][2] = 0;
        this.colores256[248][3] = 0;
        this.colores256[249][0] = 249;
        this.colores256[249][1] = 0;
        this.colores256[249][2] = 0;
        this.colores256[249][3] = 0;
        this.colores256[250][0] = 250;
        this.colores256[250][1] = 0;
        this.colores256[250][2] = 0;
        this.colores256[250][3] = 0;
        this.colores256[251][0] = 251;
        this.colores256[251][1] = 0;
        this.colores256[251][2] = 0;
        this.colores256[251][3] = 0;
        this.colores256[252][0] = 252;
        this.colores256[252][1] = 0;
        this.colores256[252][2] = 0;
        this.colores256[252][3] = 0;
        this.colores256[253][0] = 253;
        this.colores256[253][1] = 0;
        this.colores256[253][2] = 0;
        this.colores256[253][3] = 0;
        this.colores256[254][0] = 254;
        this.colores256[254][1] = 0;
        this.colores256[254][2] = 0;
        this.colores256[254][3] = 0;
        this.colores256[255][0] = 255;
        this.colores256[255][1] = 0;
        this.colores256[255][2] = 0;
        this.colores256[255][3] = 0;
    }
}

